 ; Ŀ
 ;   Bomb - rotate an ss of text/attdefs around their common centre point. 
 ;   Copyright 1995, 1997, 2010 by Rocket Software Ltd.                    
 ;   It's da ... thing ...                                                 
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   VBCX - Centre rejustify a column of text.                             
 ;   Takes three arguments: ss, the set of entities to rejustify, cc, the  
 ;   left side point, and rr, the right point.                             
 ; 
 (DEFUN VBCX (ss cc rr / xa num enam entt pty pa sp)
  (setq xa (/ (+ (car cc) (car rr)) 2))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pty (cddr (assoc 10 entt)))
         (setq pa (cons xa pty))
         (setq entt (subst (cons 72 1) (assoc 72 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vbcx end.                                                             
 ; 

 ; Ŀ
 ;   VBLX - Left rejustify a column of text.                               
 ;   Takes two arguments: ss, the selection set of entities to rejustify,  
 ;   and xa, the point on which to rejustify.                              
 ; 
 (DEFUN VBLX (ss xa / num txa aa yy ll sp)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq typ (cdr (assoc 0 entt)))
         (setq ll (cons (car xa) (cddr (assoc 10 entt))))
         (setq entt (subst (cons 10 ll) (assoc 10 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 72 0) (assoc 72 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vblx end.                                                             
 ; 

 ; Ŀ
 ;   VBRX - Right rejustify a column of text.                              
 ;   Takes two arguments: ss, the selection set of entities to rejustify,  
 ;   and xa, the point on which to rejustify.                              
 ; 
 (DEFUN VBRX (ss xa / num enam entt pty pa sp)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pty (cddr (assoc 10 entt)))
         (setq pa (cons (car xa) pty))
         (setq entt (subst (cons 72 2) (assoc 72 entt) entt))
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vbrx end.                                                             
 ; 

 ; Ŀ
 ;   Justx - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.                    
 ; 
 (DEFUN JUSTX (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
 ; Ŀ
 ;   Vertical justification.                                               
 ; 
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "B"))      ; bottom
        ((= yjust 2) (setq yjst "M"))      ; middle
        ((= yjust 3) (setq yjst "T")))     ; top
 ; Ŀ
 ;   Horizontal justification.                                             
 ; 
  (cond ((= xjust 0) (setq xjst "L"))      ; left
        ((= xjust 1) (setq xjst "C"))      ; centre
        ((= xjust 2) (setq xjst "R"))      ; right
        ((= xjust 3) (setq xjst "A"))      ; aligned
        ((= xjust 4) (setq xjst "M"))      ; middle
        ((= xjust 5) (setq xjst "F")))     ; fit
  (setq justrg (strcat yjst xjst)))
 ; Ŀ
 ;   Justx end.                                                            
 ; 

 ; Ŀ
 ;   Bock: find the box bounding the selection set of text or attdef       
 ;   entities which is passed as the sole argument.                        
 ; 
 (DEFUN BOCK (ss / num enam typ entt mxlst xmax xmin ymax ymin pl)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (setq mxlst (cron enam 0))
         (if xmax
             (setq xmax (max xmax (car mxlst)))
             (setq xmax (car mxlst)))
         (if xmin
             (setq xmin (min xmin (cadr mxlst)))
             (setq xmin (cadr mxlst)))
         (if ymax
             (setq ymax (max ymax (caddr mxlst)))
             (setq ymax (caddr mxlst)))
         (if ymin
             (setq ymin (min ymin (cadddr mxlst)))
             (setq ymin (cadddr mxlst))))
  (list (list xmin ymin) (list xmax ymax)))
 ; Ŀ
 ;   Bock end.                                                             
 ; 

 ; Ŀ
 ;   Bomb - the central planning committee.                                
 ; 
 (DEFUN C:BOMB (/ ss pts ll ur pa)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (write-line "Select text to rotate: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (if ss
      (progn
           (setq just (justx (entget (ssname ss 0))))
           (setq pts (bock ss))
           (setq ll (car pts))
           (setq ur (cadr pts))
           (grdraw ll ll 2)
           (grdraw ur ur 2)
           (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
           (command "rotate" ss "" pa "180")
           (cond ((or (= just "ML") (= just "L"))
                  (vbrx ss ur))
                 ((or (= just "MR") (= just "R"))
                  (vblx ss ll))
                 ((or (= just "M") (= just "C"))
                  (vbcx ss ll ur)))))
  (command "undo" "end")
 (princ))
